Option Explicit
Const scriptName = "Stairstep Text Selection"
Const scriptVer = "1.0.0"

' Revision History

' 1.0.0 - July 26, 2002 - MJM - Inital version.



' Script properties.
Const defStartOffset = -20
Const defEndOffset = 20

' Script constants, questions, and error messages.
Const qStartValue = "Enter starting vertical offset:"
Const qEndValue = "Enter ending vertical offset:"

Const errNoSelection = "This script requires a text selection of at least two characters."
Const errNotInRange = "Please enter a number from -100 to 100."
Const errValuesTheSame = "The values must be different."

Const minOffset = -100
Const maxOffset = 100




' Main

Dim errNum
errNum = 0

Dim CreatorApp
Set CreatorApp = WScript.CreateObject("Creator.Application")
'Set CreatorApp = GetObject(,"Creator.Application")

CreatorApp.Visible = True

Dim TextSel
If CreatorApp.Documents.Count = 0 Then
  Call MsgBox(errNoSelection, vbOkonly, scriptName)
  errNum = -1
End If

If errNum = 0 Then
  On Error Resume Next
  Set TextSel = CreatorApp.TextSelection
  errNum = Err.Number
  On Error GoTo 0
  
  If errNum <> 0 Then
    Call MsgBox(errNoSelection, vbOkonly, scriptName)
  Elseif TextSel.CharacterRuns.Count < 1 Then
    Call MsgBox(errNoSelection, vbOkonly, scriptName)
    errNum = -1
  Elseif TextSel.Start > TextSel.End Then
    Call MsgBox(errNoSelection, vbOkonly, scriptName)
    errNum = -1
  Elseif TextSel.Characters.Count < 2 Then
    Call MsgBox(errNoSelection, vbOkonly, scriptName)
    errNum = -1
  End If
End If

Dim answerText, startOffset, endOffset
Dim continueOn
If errNum = 0 Then
  continueOn = False
  startOffset = defStartOffset
  
  Do
    answerText = InputBox(qStartValue, scriptName, startOffset)
    If answerText = "" Then
      continueOn = True
      errNum = -1
    Else
  	On Error Resume Next
      startOffset = CDbl(answerText)
      errNum = Err.Number
      On Error GoTo 0

      If errNum <> 0 Then
        Call MsgBox(errNotInRange, vbOkonly, scriptName)
      Elseif (startOffset < minOffset) Or (startOffset > maxOffset) Then
        Call MsgBox(errNotInRange, vbOkonly, scriptName)
      Else
        continueOn = True
      End If
    End If
  Loop Until continueOn = True
End If

If errNum = 0 Then
  continueOn = False
  endOffset = defEndOffset
  
  If answerText <> "" Then 
    Do
      answerText = InputBox(qEndValue, scriptName, endOffset)

      If answerText = "" Then
        continueOn = True
        errNum = -1
      Else
    	  On Error Resume Next
        endOffset = CDbl(answerText)
        errNum = Err.Number
        On Error GoTo 0
        
        If errNum <> 0 Then
          Call MsgBox(errNotInRange, vbOkonly, scriptName)
        Elseif (endOffset < minOffset) Or (endOffset > maxOffset) Then
          Call MsgBox(errNotInRange, vbOkonly, scriptName)
        'Elseif endValue = startValue
          'Call MsgBox(errValuesTheSame, vbOkonly, scriptName)
        Else
          continueOn = True
        End If
      End If
    Loop Until continueOn = True
  End If
End If

' Whew!  User Interface Section Done.
If errNum = 0 Then
  Dim numChars, incAmount, theOffset
  numChars = TextSel.Characters.Count
  incAmount = (endOffset - startOffset) / (numChars - 1)
  theOffset = startOffset

  Dim char
  For Each char In TextSel.Characters
    char.VerticalOffset = theOffset
    theOffset = theOffset + incAmount
  Next
End If




